<?php
if (!defined('ABSPATH')) {
    exit;
}
if (!class_exists('Aro_Customize')) {

    class Aro_Customize {


        public function __construct() {
            add_action('customize_register', array($this, 'customize_register'));
        }

        public function get_banner() {
            global $post;

            $options[''] = esc_html__('Select Banner', 'aro');
            if (!aro_is_elementor_activated()) {
                return;
            }
            $args = array(
                'post_type'      => 'elementor_library',
                'posts_per_page' => -1,
                'orderby'        => 'title',
                's'              => 'Banner ',
                'order'          => 'ASC',
            );

            $query1 = new WP_Query($args);
            while ($query1->have_posts()) {
                $query1->the_post();
                $options[$post->post_name] = $post->post_title;
            }

            wp_reset_postdata();
            return $options;
        }

        /**
         * @param $wp_customize WP_Customize_Manager
         */
        public function tesst($wp_customize) {
            $wp_customize->add_control(
                new WP_Customize_Image_Control(
                    $wp_customize,
                    'dav_bgImage',
                    array(
                        'label'    => esc_attr__('Background image', 'aro'),
                        'section'  => 'dav_display_options',
                        'settings' => 'dav_bgImage',
                        'priority' => 8
                    )
                )
            );
        }

        public function customize_register($wp_customize) {

            /**
             * Theme options.
             */
            require_once get_theme_file_path('inc/customize-control/editor.php');
            $this->init_aro_blog($wp_customize);
            $this->aro_register_theme_customizer($wp_customize);


            if (aro_is_woocommerce_activated()) {
                $this->init_woocommerce($wp_customize);
            }

            do_action('aro_customize_register', $wp_customize);
        }

        function aro_register_theme_customizer($wp_customize) {

        } // end aro_register_theme_customizer

        /**
         * @param $wp_customize WP_Customize_Manager
         *
         * @return void
         */
        public function init_aro_blog($wp_customize) {

            $wp_customize->add_panel('aro_blog', array(
                'title' => esc_html__('Blog', 'aro'),
            ));

            // =========================================
            // Blog Archive
            // =========================================
            $wp_customize->add_section('aro_blog_archive', array(
                'title'      => esc_html__('Archive', 'aro'),
                'panel'      => 'aro_blog',
                'capability' => 'edit_theme_options',
            ));

            $wp_customize->add_setting('aro_options_blog_sidebar', array(
                'type'              => 'option',
                'default'           => 'left',
                'sanitize_callback' => 'sanitize_text_field',
            ));

            $wp_customize->add_control('aro_options_blog_sidebar', array(
                'section' => 'aro_blog_archive',
                'label'   => esc_html__('Sidebar Position', 'aro'),
                'type'    => 'select',
                'choices' => array(
                    'none'  => esc_html__('None', 'aro'),
                    'left'  => esc_html__('Left', 'aro'),
                    'right' => esc_html__('Right', 'aro'),
                ),
            ));

            $wp_customize->add_setting('aro_options_blog_style', array(
                'type'              => 'option',
                'default'           => 'standard',
                'sanitize_callback' => 'sanitize_text_field',
            ));

            $wp_customize->add_control('aro_options_blog_style', array(
                'section' => 'aro_blog_archive',
                'label'   => esc_html__('Blog style', 'aro'),
                'type'    => 'select',
                'choices' => array(
                    'standard' => esc_html__('Blog Standard', 'aro'),
                    'list'     => esc_html__('Blog List', 'aro'),
                    'style-1'  => esc_html__('Blog Grid', 'aro'),
                ),
            ));

            $wp_customize->add_setting('aro_options_blog_columns', array(
                'type'              => 'option',
                'default'           => 1,
                'sanitize_callback' => 'sanitize_text_field',
            ));

            $wp_customize->add_control('aro_options_blog_columns', array(
                'section' => 'aro_blog_archive',
                'label'   => esc_html__('Colunms', 'aro'),
                'type'    => 'select',
                'choices' => array(
                    1 => esc_html__('1', 'aro'),
                    2 => esc_html__('2', 'aro'),
                    3 => esc_html__('3', 'aro'),
                    4 => esc_html__('4', 'aro'),
                ),
            ));

            // =========================================
            // Blog Single
            // =========================================
            $wp_customize->add_section('aro_blog_single', array(
                'title'      => esc_html__('Singular', 'aro'),
                'panel'      => 'aro_blog',
                'capability' => 'edit_theme_options',
            ));
            $wp_customize->add_setting('aro_options_blog_single_sidebar', array(
                'type'              => 'option',
                'default'           => 'left',
                'sanitize_callback' => 'sanitize_text_field',
            ));

            $wp_customize->add_control('aro_options_blog_single_sidebar', array(
                'section' => 'aro_blog_single',
                'label'   => esc_html__('Sidebar Position', 'aro'),
                'type'    => 'select',
                'choices' => array(
                    'none'  => esc_html__('None', 'aro'),
                    'left'  => esc_html__('Left', 'aro'),
                    'right' => esc_html__('Right', 'aro'),
                ),
            ));
        }

        /**
         * @param $wp_customize WP_Customize_Manager
         *
         * @return void
         */


        public function init_woocommerce($wp_customize) {

            $wp_customize->add_panel('woocommerce', array(
                'title' => esc_html__('Woocommerce', 'aro'),
            ));

            $wp_customize->add_section('aro_woocommerce_archive', array(
                'title'      => esc_html__('Archive', 'aro'),
                'capability' => 'edit_theme_options',
                'panel'      => 'woocommerce',
                'priority'   => 1,
            ));

            if (aro_is_elementor_activated()) {
                $wp_customize->add_setting('aro_options_shop_banner', array(
                    'type'              => 'option',
                    'default'           => '',
                    'sanitize_callback' => 'sanitize_text_field',
                ));

                $wp_customize->add_control('aro_options_shop_banner', array(
                    'section'     => 'aro_woocommerce_archive',
                    'label'       => esc_html__('Banner', 'aro'),
                    'type'        => 'select',
                    'description' => __('Banner will take templates name prefix is "Banner"', 'aro'),
                    'choices'     => $this->get_banner()
                ));
            }

            $wp_customize->add_setting('aro_options_woocommerce_archive_layout', array(
                'type'              => 'option',
                'default'           => 'default',
                'sanitize_callback' => 'sanitize_text_field',
            ));

            $wp_customize->add_control('aro_options_woocommerce_archive_layout', array(
                'section' => 'aro_woocommerce_archive',
                'label'   => esc_html__('Layout Style', 'aro'),
                'type'    => 'select',
                'choices' => array(
                    'default' => esc_html__('Sidebar', 'aro'),
                    //====start_premium
                    'canvas'  => esc_html__('Canvas Filter', 'aro'),
                    //====end_premium
                ),
            ));

            $wp_customize->add_setting('aro_options_woocommerce_archive_sidebar', array(
                'type'              => 'option',
                'default'           => 'left',
                'sanitize_callback' => 'sanitize_text_field',
            ));

            $wp_customize->add_control('aro_options_woocommerce_archive_sidebar', array(
                'section' => 'aro_woocommerce_archive',
                'label'   => esc_html__('Sidebar Position', 'aro'),
                'type'    => 'select',
                'choices' => array(
                    'left'  => esc_html__('Left', 'aro'),
                    'right' => esc_html__('Right', 'aro'),

                ),
            ));

            // =========================================
            // Single Product
            // =========================================

            $wp_customize->add_section('aro_woocommerce_single', array(
                'title'      => esc_html__('Singular', 'aro'),
                'capability' => 'edit_theme_options',
                'panel'      => 'woocommerce',
                'priority'   => 1,
            ));

            $wp_customize->add_setting('aro_options_single_product_gallery_layout', array(
                'type'              => 'option',
                'default'           => 'horizontal',
                'transport'         => 'refresh',
                'sanitize_callback' => 'sanitize_text_field',
            ));
            $wp_customize->add_control('aro_options_single_product_gallery_layout', array(
                'section' => 'aro_woocommerce_single',
                'label'   => esc_html__('Style', 'aro'),
                'type'    => 'select',
                'choices' => array(
                    'horizontal' => esc_html__('Horizontal', 'aro'),
                    //====start_premium
                    'vertical'   => esc_html__('Vertical', 'aro'),
                    'gallery'    => esc_html__('Gallery', 'aro'),
                    'sticky'     => esc_html__('Sticky', 'aro'),
                    //====end_premium
                ),
            ));

            $wp_customize->add_setting(
                'aro_options_single_product_content_meta',
                array(
                    /* translators: %s privacy policy page name and link */
                    'type'              => 'option',
                    'sanitize_callback' => 'wp_kses_post',
                    'capability'        => 'edit_theme_options',
                    'transport'         => 'postMessage',
                )
            );

            $wp_customize->add_control(
                'aro_options_single_product_content_meta',
                array(

                    'label'    => esc_html__('Single extra description', 'aro'),
                    'section'  => 'aro_woocommerce_single',
                    'settings' => 'aro_options_single_product_content_meta',
                    'type'     => 'textarea',
                )
            );

            // =========================================
            // Product
            // =========================================
            $wp_customize->add_setting('aro_options_wocommerce_row_laptop', array(
                'type'              => 'option',
                'default'           => 3,
                'transport'         => 'postMessage',
                'sanitize_callback' => 'sanitize_text_field',
            ));

            $wp_customize->add_control('aro_options_wocommerce_row_laptop', array(
                'section' => 'woocommerce_product_catalog',
                'label'   => esc_html__('Products per row Laptop', 'aro'),
                'type'    => 'number',
            ));

            $wp_customize->add_setting('aro_options_wocommerce_row_tablet', array(
                'type'              => 'option',
                'default'           => 2,
                'transport'         => 'postMessage',
                'sanitize_callback' => 'sanitize_text_field',
            ));

            $wp_customize->add_control('aro_options_wocommerce_row_tablet', array(
                'section' => 'woocommerce_product_catalog',
                'label'   => esc_html__('Products per row tablet', 'aro'),
                'type'    => 'number',
            ));

            $wp_customize->add_setting('aro_options_wocommerce_row_mobile', array(
                'type'              => 'option',
                'default'           => 1,
                'transport'         => 'postMessage',
                'sanitize_callback' => 'sanitize_text_field',
            ));

            $wp_customize->add_control('aro_options_wocommerce_row_mobile', array(
                'section' => 'woocommerce_product_catalog',
                'label'   => esc_html__('Products per row mobile', 'aro'),
                'type'    => 'number',
            ));

        }
    }
}
return new Aro_Customize();
